<?php

/**
 *
 * @link       http://michael.lapkin.net/bandaid
 * @since      1.0.0
 * @package    Band_Aid
 * @subpackage Band_Aid/includes
 * @author     Michael Lapkin <mslapkin@gmail.com>
 */
class Band_Aid {

	/**
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Band_Aid_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $band_aid    The string used to uniquely identify this plugin.
	 */
	protected $band_aid;

	/**
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'BAND_AID_VERSION' ) ) {
			$this->version = BAND_AID_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->band_aid = 'band-aid';

		$this->load_dependencies();
		$this->define_public_hooks();

	}

	/**
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-band-aid-loader.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-band-aid-public.php';

		$this->loader = new Band_Aid_Loader();

	}


	/**
	 * Register hooks 
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Band_Aid_Public( $this->get_band_aid(), $this->get_version() );
		$this->loader->add_action( 'init', $plugin_public, 'init_shortcode' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );
	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_band_aid() {
		return $this->band_aid;
	}

	/**
	 *
	 * @since     1.0.0
	 * @return    Band_Aid_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

}
